<?Lassoscript
/* Adding method for loading record from database */

//please observe that this is _not_ the best way of handling the db/user/password info
//see note about this in the end of the paper
var: 'gDBspec' = (array: -database='LS6CType', -username='demouser', -password='demopass');

Define_Type: 'C_Contact', -prototype;
	local: 'key' = 0;			//unique key to identify record
	local: 'firstname' = '';
	local: 'lastname' = '';
	
	Define_Tag: 'setName', -required='firstname', -required='lastname';
		self->'firstname' = #firstname;
		self->'lastname' = #lastname;
	/Define_Tag;
	
	Define_Tag: 'getName';
		return: self->'firstname' + ' ' + self->'lastname';
	/Define_Tag;

	Define_Tag: 'getKey';		//getting the the key instance variable
		return: self->key;
	/Define_Tag;
	
	Define_Tag: 'hasValidKey';
		return: self->key > 0;
	/Define_Tag;
	
	/* You will rarely use the setKey method from outside of this custom type */
	Define_Tag: 'setKey', -required='key';	//setting the key instance variable
		self->'key' = (integer: #key);
	/Define_Tag;
	
	Define_Tag: 'load', -required='key';
		inline: -search, $gDBspec, -table='contact', -keyfield='key', -keyvalue=(integer: #key), -maxrecords=1;
			records;
				self->LoadX;
			/records;
		/inline;
	/Define_Tag;
	
	Define_Tag: 'loadX';
		self->(setKey: -key=(field: 'key'));
		self->'firstname' = (field: 'firstname');
		self->'lastname' = (field: 'lastname');
	/Define_Tag;
	
	Define_Tag: 'save';
		if: self->GetKey == 0;	//this is an add operation
			inline: -add, $gDBspec, -table='contact', -keyfield='key', -keyvalue=self->GetKey,
				'firstname'=self->'firstname',
				'lastname'=self->'lastname';
				self->(setKey: -key=keyfield_value);		//it is important to set the key of the object
			/inline;
		else;	//this is an update operation
			inline: -update, $gDBspec, -table='contact', -keyfield='key', -keyvalue=self->GetKey,
				'firstname'=self->'firstname',
				'lastname'=self->'lastname';
			/inline;			
		/if;
	/Define_Tag;
	

	Define_Tag: 'getContactList';
		local: 'result' = array;
		
		local: 'oneRecord' = map;
		inline: -search, $gDBspec, -table='contact', -keyfield='key', -maxrecords='all';
			records;
				#oneRecord = C_Contact;
				#oneRecord->loadX;
				#result->(insert: #oneRecord);
			/records;
		/inline;
		return: #result;
	/Define_Tag;
/Define_Type;

?>